package gov.va.vamf.scheduling.varutility.resources;

import gov.va.vamf.scheduling.varutility.clientapi.MobileHealthClientTestVersion;
import gov.va.vamf.scheduling.varutility.domain.*;
import gov.va.vamf.scheduling.varutility.testutility.IntegrationTestConfiguration;
import gov.va.vamf.scheduling.varutility.testutility.TestHelper;
import org.junit.*;

import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import java.net.URI;

public class VarUtilityCustomTextFormTest {
    private static MobileHealthClientTestVersion client;
    private static Client jerseyClient;
    private static final String SITE_CODE = "test-site-code-1";
    private static final String[] messageIds = {"appointmentNoPreferredDatePopup", "typeOfCareDropdown", "noClinicRadioButtons"};
    private static final String CUSTOM_MESSAGE_TEXT = "Custom message text ";
    private static final String CUSTOM_FRIENDLY_TEXT = "Custom friendly text";

    @BeforeClass
    public static void startup() {
        client = TestHelper.createProviderClient();
        jerseyClient = client.getJerseyClient();
    }

    @AfterClass
    public static void destroy() {
        if (client != null) {
            client.getJerseyClient().close();
            client = null;
        }
    }

    @Test
    public void testDefaultCustomFriendlyText() {
        testSaveCustomFriendlyText();
        testFetchDefaultCustomFriendlyText();
        testDeleteCustomFriendlyText();
    }

    @Test
    public void testNotNullCustomTextForm() {
        testSaveCustomTextForm(CUSTOM_FRIENDLY_TEXT);
        testFetchCustomTextForm();
        testDeleteCustomTextForm();
    }

    @Test
    public void testNullCustomTextForm() {
        testSaveCustomTextForm(CUSTOM_FRIENDLY_TEXT);
        testFetchCustomTextForm();
        testSaveCustomTextForm(null);
        testDeleteCustomMessages();
    }

    @Test
    public void testFetchDefaultCustomMessage() {
        for (int i = 0; i < messageIds.length; i++) {
            CustomMessage foundDefaultCustomMessage = jerseyClient.target(getDefaultCustomMessageResourceUri(messageIds[i]))
                    .request()
                    .accept(MediaType.APPLICATION_JSON)
                    .get(CustomMessage.class);

            Assert.assertEquals(messageIds[i], foundDefaultCustomMessage.getMessageId());
        }
    }

    private void testSaveCustomFriendlyText () {
        CustomFriendlyText putPayload = createCustomFriendlyTextPayload(SITE_CODE, CUSTOM_FRIENDLY_TEXT);

        CustomFriendlyText savedCustomFriendlyText = jerseyClient.target(getCustomFriendlyTextResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .put(Entity.json(putPayload), CustomFriendlyText.class);

        Assert.assertNotNull(savedCustomFriendlyText);
        Assert.assertNotNull(savedCustomFriendlyText.getSiteCode());
        Assert.assertTrue(savedCustomFriendlyText.getFriendlyText().length() > 0);
    }

    private void testSaveCustomTextForm(String customFriendlyText) {

        CustomTextForm putPayload = createCustomTextFormPayload(SITE_CODE, customFriendlyText);

        CustomTextForm savedCustomTextForm = jerseyClient.target(getCustomTextFormResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .put(Entity.json(putPayload), CustomTextForm.class);

        Assert.assertNotNull(savedCustomTextForm);
        Assert.assertNotNull(savedCustomTextForm.getSiteCode());
        Assert.assertNotNull(savedCustomTextForm.getUserFriendlyText());
        Assert.assertTrue(savedCustomTextForm.getCustomMessages().size() > 0);
    }

    private void testFetchDefaultCustomFriendlyText() {

        CustomFriendlyText foundDefaultCustomFriendlyText= jerseyClient.target(getDefaultCustomFriendlyTextResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .get(CustomFriendlyText.class);

        Assert.assertNotNull(foundDefaultCustomFriendlyText);
        Assert.assertNotNull(foundDefaultCustomFriendlyText.getSiteCode());
        Assert.assertNotNull(foundDefaultCustomFriendlyText.getFriendlyText());
    }

    private void testFetchCustomTextForm() {

        CustomTextForm foundCustomTextForm = jerseyClient.target(getCustomTextFormResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .get(CustomTextForm.class);

        Assert.assertNotNull(foundCustomTextForm);
        Assert.assertNotNull(foundCustomTextForm.getUserFriendlyText());
        Assert.assertTrue(foundCustomTextForm.getCustomMessages().size() > 0);
    }

    private void testDeleteCustomMessages() {
        CustomMessages deletedCustomMessages = jerseyClient.target(getCustomMessageResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .delete(CustomMessages.class);

        Assert.assertNotNull(deletedCustomMessages);
    }

    private static URI getCustomTextFormResourceUri(String siteCode) {
        String uriFormat = String.format("%s/custom-text-form/site/%s",
                IntegrationTestConfiguration.getServerBaseUri(), siteCode);

        return UriBuilder.fromUri(uriFormat).build();
    }

    private static URI getDefaultCustomMessageResourceUri(String messageId) {
        String uriFormat = String.format("%s/custom-text-form/default-message/message-id/%s",
                IntegrationTestConfiguration.getServerBaseUri(), messageId);

        return UriBuilder.fromUri(uriFormat).build();
    }

    private static URI getCustomMessageResourceUri(String siteCode) {
        String uriFormat = String.format("%s/custom-text-form/custom-messages/site/%s",
                IntegrationTestConfiguration.getServerBaseUri(), siteCode);

        return UriBuilder.fromUri(uriFormat).build();
    }

    private static URI getCustomFriendlyTextResourceUri(String siteCode) {
        String uriFormat = String.format("%s/custom-text-form/custom-friendly-text/site/%s",
                IntegrationTestConfiguration.getServerBaseUri(), siteCode);

        return UriBuilder.fromUri(uriFormat).build();
    }

    private static URI getDefaultCustomFriendlyTextResourceUri(String siteCode) {
        String uriFormat = String.format("%s/custom-text-form/default-custom-friendly-text/site/%s",
                IntegrationTestConfiguration.getServerBaseUri(), siteCode);

        return UriBuilder.fromUri(uriFormat).build();
    }

    private void testDeleteCustomTextForm() {
        CustomTextForm deletedCustomTextForm = jerseyClient.target(getCustomTextFormResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .delete(CustomTextForm.class);

        Assert.assertNotNull(deletedCustomTextForm);
    }

    private void testDeleteCustomFriendlyText() {
        CustomFriendlyTexts deletedCustomFriendlyTexts = jerseyClient.target(getCustomFriendlyTextResourceUri(SITE_CODE))
                .request()
                .accept(MediaType.APPLICATION_JSON)
                .delete(CustomFriendlyTexts.class);

        Assert.assertNotNull(deletedCustomFriendlyTexts);
    }


    private CustomTextForm createCustomTextFormPayload(String siteCode, String friendlyText) {
        CustomTextForm customTextForm = new CustomTextForm();
        customTextForm.setSiteCode(siteCode);
        customTextForm.setUserFriendlyText(friendlyText);

        CustomMessages customMessages = new CustomMessages();

        for (int i = 0; i < messageIds.length; i++) {
            CustomMessage customMessage = new CustomMessage();
            customMessage.setSiteCode(siteCode);
            customMessage.setMessageId(messageIds[i]);
            customMessage.setMessageText(CUSTOM_MESSAGE_TEXT + String.valueOf(i + 1));
            customMessages.add(customMessage);
        }

        customTextForm.setCustomMessages(customMessages);

        return customTextForm;
    }

    private CustomFriendlyText createCustomFriendlyTextPayload(String siteCode, String friendlyText) {
        CustomFriendlyText customFriendlyText = new CustomFriendlyText();
        customFriendlyText.setSiteCode(siteCode);
        customFriendlyText.setFriendlyText(friendlyText);

         return customFriendlyText;
    }

}
